#include "SDLSound.h"
#include <iostream>

#pragma message("		Adding SDL lib...")
#pragma comment(lib, "SDL.lib")
#pragma comment(lib, "SDLmain.lib")


namespace XFaceApp
{
	Uint8 * SDLSound::s_audio_chunk = 0;
	Uint32 SDLSound::s_audio_remains = 0;
	Uint8 * SDLSound::s_audio_pos = 0;
	bool SDLSound::s_bMute = false;

	SDLSound::SDLSound(void) : m_audio_len(0)
	{
		SDL_Init(SDL_INIT_AUDIO);
	}

	SDLSound::~SDLSound(void)
	{
		unload();
	}

	void SDLSound::playSound(void *udata, Uint8 *stream, int len)
	{
		if ( s_audio_remains == 0 )
		{
			return;
		}

		len = ( len > (int)s_audio_remains ? s_audio_remains : len );
		if(!s_bMute)
		{
			SDL_MixAudio(stream, s_audio_pos, len, SDL_MIX_MAXVOLUME);
		}
		s_audio_pos += len;
		s_audio_remains -= len;
	}

	bool SDLSound::loadWAV(const std::string& filename)
	{
		unload();
		bool oldMute = s_bMute;
		s_bMute = true;
		SDL_AudioSpec wav_spec;

		if( SDL_LoadWAV(filename.c_str(), &wav_spec, &s_audio_chunk, &m_audio_len) == NULL )
		{
			return false;
		}

		wav_spec.callback = SDLSound::playSound;
		wav_spec.userdata = NULL;

		SDL_CloseAudio();
		if ( SDL_OpenAudio(&wav_spec, NULL) < 0 ) 
		{
			return false;
		}

		s_audio_pos = s_audio_chunk;
		s_audio_remains = m_audio_len;

		s_bMute = oldMute;
		return true;
	}

	void SDLSound::mute(bool bMute)
	{
		s_bMute = bMute;
	}

	void SDLSound::jump(float percentage)
	{
		if(percentage > 1.0f)
		{
			return;
		}
		Uint32 newpos = Uint32(percentage*(float)m_audio_len);
		if(newpos % 2)
		{
			newpos++;
		}
		s_audio_pos = &s_audio_chunk[newpos];
		s_audio_remains = m_audio_len - newpos;
	}

	void SDLSound::play()
	{
		SDL_LockAudio();
		if(m_audio_len)
		{
			s_audio_pos = s_audio_chunk;
			s_audio_remains = m_audio_len;
			SDL_PauseAudio(0);
		}

		SDL_UnlockAudio();
				
	}

	void SDLSound::pause()
	{
		SDL_LockAudio();
		SDL_audiostatus status = SDL_GetAudioStatus();
		if (SDL_AUDIO_PLAYING == status)
		{
			SDL_PauseAudio(1);
		}
		else if ((SDL_AUDIO_PAUSED == status) || (SDL_AUDIO_STOPPED == status))
		{
			SDL_PauseAudio(0);
		}

		SDL_UnlockAudio();
	}

	void SDLSound::stop()
	{
		SDL_LockAudio();
		SDL_PauseAudio(1);
		s_audio_pos = s_audio_chunk;
		s_audio_remains = m_audio_len;
		SDL_UnlockAudio();
	}

	void SDLSound::unload()
	{
		SDL_audiostatus status = SDL_GetAudioStatus();
		if (SDL_AUDIO_PLAYING == status)
		{
			SDL_PauseAudio(1);
		}
		
		SDL_FreeWAV(s_audio_chunk);
		s_audio_chunk = 0;
		m_audio_len = 0;
		s_audio_remains = 0;
		s_audio_pos = 0;

		SDL_CloseAudio();
	}
}// namespace XFaceApp